/************************************************************************
* \file: trace_common.h
*
* \version: $Id: trace_linux.h,v 1.0 2010/08/04 
*
* Declares structures/definitions common to all variants
* \component: Gen2 Trace
*
* \author Arun V
*         Sakthivelu.S
*
* \copyright: (c) 2003 - 2009 ADIT
*
***********************************************************************/
#ifndef _TRACE_COMMON_H_
#define _TRACE_COMMON_H_

typedef long TRACE_LONG;


#define TR_CLASS_MST_TESTER             24U
#define TRACE_ISP_CMD_DATA              0x0001

#define TRACE_DEVNM_LEN                 255
#define TRACE_FILE_NM_LEN               255
 
#define TRACE_PROXY_BIN_FILE_OVWR_FIELD 5U
#define TRACE_PROXY_BIN_FILE_STAT_FIELD 4U
#define TRACE_PROXY_FILE_SIGN       0x04000000U  /* in BigEndian format,LE = 0x00000004U */
#define TRACE_PROXY_MSG_SIGN        0xFFFFFF04U  /* in BigEndian format,LE = 0x04FFFFFFU */
#define TRACE_BIN_FILE_EMPTY        0U
#define TRACE_BIN_FILE_FULL         1U
#define TRACE_BIN_FILE_PARTLY_FULL  2U
#define TRACE_MAX_CLASS             0x10000
#define TRACE_STORAGE_DEV_LEN       TRACE_DEVNM_LEN

#define TRACE_SHUTDOWNOPTION        (2U)

#define L_IPADDR                    15
#define TRACE_MAX_COMP_CNT          256

#define TRACE_MAX_CHAN_CNT          (1024 * 8)

#define TRACE_MIN_PKT_CNT           0x01U
#define TRACE_MAX_PKT_CNT           245U   /*255-10bytes for control bytes */

#define TRACE_IO_RTRY_CNT           0x05

#define TRACE_LARGE_MSG_SZ         ((129 * 1024) -8)  /* 8 bytes are for header */
#define TRACE_NORMAL_MSG_SZ         240U

#define TRACE_MIN_FRAME_CNT         0x01
#define TRACE_MAX_FRAME_CNT         245U

#define TRACE_MAX_FRAME_SZ          512U

#define TRACE_CHAN_BUF_FRAME_SIZE   610

#define TR_PROXY_MAX_MSG_SZ         256
/*jov1kor-CRQ.No-XXXX- Implementation for Trace Internal Commands*/
#define TR_SEND_CMD_MSG_SZ 256

#define TR_CLASS_PER_BYTE            2
/* TCPIP packet size */
#define TRACE_MIN_PKT_SZ            0x02
#define TRACE_MAX_PKT_SZ            248
#define TRACE_PKTSZ_FIELD           0x00U

#define TRACE_RD_1_BYTE             0x01
#define TRACE_LEN_FIELD             0x00
#define TRACE_DAT                   0x01
#define TRACE_SINGLE_FRAME          ((U8)0x01)
#define TRACE_FRAME_CNT             ((U8)0x00)

#define TRACE_INVALID_TSKID         (-1)
/* Incoming payload offset for blockmode value */
#define TRACE_BLCKMODE_OFFSET       ((U8)0x02)

/* Incoming payload offset for Trip */
#define TRACE_TRIP_OFFSET           ((U8)0x02)

/* Incoming payload offset for app filter */
#define TRACE_APPFILTER_OFFSET      ((U8)0x02)

/* Incoming payload offset for stat flag */
#define TRACE_STAT_OFFSET           ((U8)0x02)

/* Incoming payload offset for timestamp value */
#define TRACE_TIMESTAMP_OFFSET      ((U8)0x02)

/* Incoming payload offset for port value */
#define TRACE_PORT_OFFSET           ((U8)0x02)

/* Outgoing payload offset for connection status value */
#define TRACE_CNCT_STAT_OFFSET      ((U8)0x00)

/* Incoming payload offset for level value */
#define TRACE_LVL_OFFSET            ((U8)0x02)

/* Trace proxy config append setting offset */
#define TRACE_PROXY_APPEND_OFFSET   ((U8)0x01)

/* Incoming payload offset for prxy timestamp */
#define TRACE_PROXY_TIMESTAMP_OFFSET ((U8)0x02)

/*Block mode support for proxy */
#define TRACE_PROXY_BLOCKMODE_OFFSET ((U8)0x02)

/* Trace Proxy file name offset */
#define TRACE_PROXY_FILE_NM_OFFSET  ((U8)0x04)

#define TRACE_PROXY_HDR_SZ          ((U8)0x09)

#define TRACE_PROXY_NOAPPEND        ((U8)0x00)

/* Disable levels for all class */
#define TRACE_DISABLE_ALL_CLS_LVL   ((S8)-1)

/* Incoming payload offset for class level value*/
#define TRACE_CLAS_OFFSET_0         ((U8)0x02)
#define TRACE_CLAS_OFFSET_1         ((U8)0x03)
#define TRACE_CLAS_OFFSET_2         ((U8)0x04)

#define TRACE_MEDIA_ALL             (TRACE_UDA0 | TRACE_UDA1)
#define TRACE_PROXY_OVWR_MODE       TRUE
#define TRACE_FILE_W_PLUS           (O_RDWR | O_CREAT | O_TRUNC)
#define TRACE_FILE_R_PLUS           (O_RDWR)
#define TRACE_FILE_A_PLUS           (O_RDWR | O_CREAT | O_APPEND)
#define TRACE_FILE_RD_ONLY          (O_RDONLY)
#define TRACE_FILE_WR_ONLY          (O_WRONLY | O_CREAT | O_TRUNC)
#define TRACE_FILE_ACCESS_MODE      (S_IRWXU | S_IRWXG | S_IRWXO)
#define TRACE_PROXY_BIN_FILE_EXTN   ".bin"

#define TRACE_PROXY_BIN_FILE_NM     "/proxy_trace"
#define TRACE_PROXY_DAT_FILE_NM     "/proxy_trace.dat"
#define TRACE_PROXY_CFG_FILE_NM     "/proxy_cnfg.cfg"
#define TRACE_CLAS_CFG_FILE_NM      "/tr_class_cnfg.cfg"
#define TRACE_DEV_CFG_FILE_NM       "/tr_dev_cnfg.cfg"

#define TRACE_KB_SZ                 1024

#define TRACE_DLL_LOAD              0
#define TRACE_DLL_UNLOAD            1

#define TRACE_LOW_NIBBLE            0xf

#define TRACE_MASK                  0x0f
#define PROXY_MASK                  0xf0
#define LEVEL_MASK                  TRACE_MASK
#define TRACE_MAX_DEVCNF_ITEM       32
#define TRACE_SYSPRG_PRI            80

#define TRACE_INVALID_ID            (0xFFFF)

#define TRACE_FRAME_SUB_SZ          (sizeof(U8))

#define TRACE_FRAME_PAYLD_SZ        (sizeof(TRACE_OUT_PKT))

#define TRACE_MAX_SUB_PKT           2

#define TRACE_EVTPTN(x)             (0x00000001 << x)

#define TRACE_MAX_RETRY_CNT         3

/* Trip in TTfis  */
typedef enum
{
  TRIP_REC    = 0x00,     /* rec trip in trace */
  TRIP_REPLAY = 0x01,     /* replay trip       */
  NO_TRIP     = 0x02      /* no trip           */
}TRACE_trip_mode;

typedef enum
{
  TRACE_DISABLE = 0x00,
  TRACE_ENABLE  = 0x01
}TRACE_FLAGS;

typedef enum
{
  TRACE_INDEX_0   = 0x00,
  TRACE_INDEX_1   = 0x01,
  TRACE_INDEX_2   = 0x02,
  TRACE_INDEX_3   = 0x03,
  TRACE_INDEX_4   = 0x04,
  TRACE_INDEX_5   = 0x05,
  TRACE_INDEX_6   = 0x06,
  TRACE_INDEX_7   = 0x07,
  TRACE_INDEX_8   = 0x08,
  TRACE_INDEX_9   = 0x09,
  TRACE_INDEX_10  = 0xa,
  TRACE_INDEX_11  = 0xb,
  TRACE_MAX_INDEX
}TRACE_FE_INIT;

typedef enum
{
  TRACE_SHIFT_32bits        = 0x20,
  TRACE_SHIFT_24bits        = 0x18,
  TRACE_SHIFT_16bits        = 0x10,
  TRACE_SHIFT_8bits         = 0x08,
  TRACE_POS_0               = 0,
  TRACE_POS_1               = 1,
  TRACE_POS_2               = 2,
  TRACE_POS_3               = 3,
  TRACE_BYTE_MASK           = 0xff,
  TRACE_SHORT_MASK          = 0xff00
}TRACE_SHIFT_BY_BITS;

typedef enum
{
  TRACE_STATUS_INFO    = 0x00,
  TRACE_GET_CONNECTION = 0x01,
  TRACE_TIMESTAMP      = 0x02,
  TRACE_OVRCNT_INFO    = 0x03,
  TRACE_COMM_ERR       = 0x04,
  TRACE_CLAS_CNFG      = 0x05,
  TRACE_BUF_MODE       = 0x07,
  TRACE_PMM_STATUS     = 0x08,
  TRACE_NO_SPT         = 0x0a,
  TRACE_APPFILTER_STAT = 0x0c,
  TRACE_DBG_EXTN       = 0x0e,
  TRACE_TTFIS_CLS_INFO = 0x0f,
  TRACE_PROXY_CLS_INFO = 0x10,
  TRACE_TRACE_SET_INFO = 0x11,
  TRACE_PROXY_SET_INFO = 0x12
}TRACE_con_stat;


typedef enum
{
  TRACE_CMD_NO_SPT     = 0x00,
  TRACE_COMM_ERR_RESET = 0x00,
  TRACE_COMM_ERR_SET   = 0x01,
  TRACE_CHAN_NOT_REG   = 0x01,
  TRACE_INVALID_MSG_SZ = 0x02,
  TRACE_SWITCH_CHNL    = 0x03,
  TRACE_NO_PMM         = 0x04,
  TRACE_INVALID_CMD    = 0x05,
  TRACE_MSG_INVALID    = 0x06,
  TRACE_PERM_DENIED    = 0x07 
}TRACE_sub_err;


/* Trace main commands */
typedef enum
{
  TRACE_COMMAND           = 0x01,
  TRACE_GET_CHNL          = 0x02,
  TRACE_COMMAND_PLATFORM  = 0x03,
  TRACE_PMM_COMMAND       = 0x04,
  TRACE_DBUG_XTENSION     = 0x05
}TRACE_cmd;

/* Trace sub-commands */
typedef enum
{
  TRACE_TEST_CONNECTION         = 0x01,
  TRACE_SET_CONFIG              = 0x02,
  TRACE_STOP_TRACE              = 0x05,
  TRACE_ENABLE_TIMESTAMP        = 0x06,
  TRACE_DISABLE_TIMESTAMP       = 0x07,
  TRACE_ENABLE_BLOCKMODE        = 0x08,
  TRACE_CHANGE_PORT             = 0x09,
  TRACE_SET_TRCNFG_GRP          = 0x0b,
  TRACE_STOP_TRCNFG_GRP         = 0x0c,
  TRACE_SAVE_TRACE_CNFG         = 0x0d,
  TRACE_CNFG_ENABLE_ALL         = 0x0e,
  TRACE_CNFG_DISABLE_ALL        = 0x0f,
  TRACE_QUERY_BLOCKMODE         = 0x10,
  TRACE_TTFIS_QUERY_CLASSES     = 0x11,
  TRACE_PROXY_QUERY_CLASSES     = 0x12,
  TRACE_TRACE_QUERY_SETTINGS    = 0x13,
  TRACE_PROXY_QUERY_SETTINGS    = 0x14,
  TRACE_REG_CHNL_INFO           = 0x15,
  /* Assigned enum value for TRACE_FACTORY_RESET to 0x18 to match with Gen4 Trace macro */
  TRACE_FACTORY_RESET           = 0x18
}TRACE_subcmd;

typedef enum
{
  TRACE_PRXY_SAVE_CFG     = 0x00,
  TRACE_TRIP_MODE         = 0x01,
  TRACE_STAT_MODE         = 0x02,
  TRACE_PRXY_TSTAMP       = 0x03,
  TRACE_PRXY_FILESZ       = 0x04,
  TRACE_SET_APPFILTER     = 0x05,
  TRACE_GET_APPFILTER     = 0x06,
  TRACE_PRXY_BLKMODE      = 0x07,
  TRACE_MAX_PRXY_SZ       = 0x08
}TRACE_plat_subcmd;


/* IO channel used for communication */
typedef enum
{
  TRACE_NULLDEV    = 0x00,
  TRACE_UART       = 0x01,
  TRACE_USBF       = 0x02,
  TRACE_PROXY      = 0x03,
  TRACE_SIM        = 0x04,
  TRACE_PCIe       = 0x05, /* not used, kept for backward compatibility */
  TRACE_TCPIP      = 0x06,
  TRACE_USBH       = 0x07,
  TRACE_MAX_IO_DEV = 0x08
}TRACE_iodev;

#define TRACE_VALID_TIMESTAMP \
(TRACE_TIMESTAMP_32BIT | TRACE_TIMESTAMP_64BIT | TRACE_TIMESTAMP_RTC)

/* Buffer fill status msg */
typedef enum
{
  TRACE_STATUS_SND_DISABLE = 0x00,  /* Do not send buffer status msg */
  TRACE_STATUS_SND_ENABLE  = 0x01   /* Send buffer status msg        */
}TRACE_stat_mode;

/* Traceout message type */
typedef enum
{
  TR_MSG_NORMAL    = 0x00,
  TR_MSG_MULTIPKT  = 0x01
}TRACE_msg_type;

typedef enum
{
  TR_MSG_MULTI_START  = TR_MSG_MULTIPKT,
  TR_MSG_MULTI_MIDDLE = 0x02,
  TR_MSG_MULTI_END    = 0x03
}TRACE_multi_pack_ms;

/* status msg */
enum _TRACE_stat_msg
{
  TR_STAT_TIME_MSG = 0x02
};

/* Flowcontrl for trace-over-uart */
typedef enum
{
  TRACE_ACK     = 0x00,
  TRACE_NACK    = 0xFF,
  TRACE_SYNC    = 0xFE,
  TRACE_RESET   = 0xFD,
  TRACE_NO_SIG  = 0xFFFFFFF
}TRACE_flowctrl;

/* Trace checksum reference value */
typedef enum
{
  TRACE_TX_CHECKSUM = 0x55,
  TRACE_RX_CHECKSUM = 0xaa
}TRACE_checksum;

/* Trace event bit distribution */
typedef enum
{
  /* Request WR task to switch physical device */
  TRACE_CHNL_SWTCH_WRT           = TRACE_EVTPTN(0),
  TRACE_CHNL_SWTCH_WAKEUP_WRT    = TRACE_EVTPTN(0),

  /* Request RD task to switch physical device */
  TRACE_CHNL_SWTCH_RDT           = TRACE_EVTPTN(1),
  TRACE_CHNL_SWTCH_WAKEUP_RDT    = TRACE_EVTPTN(1),

  /* Wakeup WR task as ACK/NACK is received */
  TRACE_ACK_SND_WRT             = TRACE_EVTPTN(2),
  TRACE_NACK_SND_WRT            = TRACE_EVTPTN(3),

  /* WR task wait on ACK/NACK */
  TRACE_ACK_WAIT_WRT             = TRACE_EVTPTN(2),
  TRACE_NACK_WAIT_WRT            = TRACE_EVTPTN(3),

  /* Wakeup switch task to switch physical channel */
  TRACE_INI_CHNL_SWTCH          = TRACE_EVTPTN(4),

  /* Data available in trace buffer */
  TRACE_DAT_AVL_TRC_BUF         = TRACE_EVTPTN(5),

  /* Wait for space in trace buffer */
  TRACE_WAIT_4_TRC_BUF_SPACE    = TRACE_EVTPTN(6),

  /* Data available in channel buffer */
  TRACE_DAT_AVL_CHNL_BUF         = TRACE_EVTPTN(7),

  /* Wait for space in channel buffer */
  TRACE_WAIT_4_CHNL_BUF_SPACE    = TRACE_EVTPTN(8),

  /* Data available in status buffer */
  TRACE_DAT_AVL_STAT_BUF         = TRACE_EVTPTN(9),

  /* Wait for space in status buffer */
  TRACE_WAIT_4_STAT_BUF_SPACE    = TRACE_EVTPTN(10),

  /* Wakeup TCPIP WR task after connection reestablishment */
  TRACE_WKUP_TCPCIP_WRT          = TRACE_EVTPTN(11),
  TRACE_TCPCIP_WAI_4_RDT_SIG     = TRACE_EVTPTN(11),

  /* Trace Proxy media attach */
  TRACE_PROXY_MEDIA_ATTACH = TRACE_EVTPTN(12),

  /* Trace Proxy media detach */
  TRACE_PROXY_MEDIA_DETACH = TRACE_EVTPTN(13),

  /* Data available in proxy buffer */
  TRACE_DAT_AVL_PRXY_BUF         = TRACE_EVTPTN(14),

  /* Wait for space in proxy buffer */
  TRACE_WAIT_4_PRXY_BUF_SPACE    = TRACE_EVTPTN(15),

  TRACE_WAI_WR_CTRL         = TRACE_EVTPTN(16),
  TRACE_SIG_WR_SELF         = TRACE_EVTPTN(16),

  TRACE_WAI_RD_CTRL         = TRACE_EVTPTN(17),
  TRACE_SIG_RD_SELF	    = TRACE_EVTPTN(17),

  TRACE_SIG_SEND_CMD_TSK    = TRACE_EVTPTN(18),
}TRACE_evt_ptn;

#endif /*_TRACE_COMMON_H_*/

